﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Window.Sample8
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool SetWindowPos(IntPtr hWnd, SetWindowPosInsertAfterFlags hWndInsertAfter, int x, int y, int cx, int cy, SetWindowPosFlags uFlags);

        public enum SetWindowPosFlags : uint
        {
            SWP_ASYNCWINDOWPOS = 0x4000,
            SWP_DEFERERASE = 0x2000,
            SWP_DRAWFRAME = 0x20,
            SWP_FRAMECHANGED = 0x20,
            SWP_HIDEWINDOW = 0x80,
            SWP_NOACTIVATE = 0x10,
            SWP_NOCOPYBITS = 0x100,
            SWP_NOMOVE = 0x2,
            SWP_NOOWNERZORDER = 0x200,
            SWP_NOREDRAW = 0x8,
            SWP_NOREPOSITION = 0x200,
            SWP_NOSENDCHANGING = 0x400,
            SWP_NOSIZE = 0x1,
            SWP_NOZORDER = 0x4,
            SWP_SHOWWINDOW = 0x40,
        }

        public enum SetWindowPosInsertAfterFlags : int
        {
            HWND_TOP = 0,
            HWND_BOTTOM = 1,
            HWND_TOPMOST = -1,
            HWND_NOTOPMOST = -2
        }

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonWindowTopMost_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = this.Handle;
            SetWindowPos(hWnd, SetWindowPosInsertAfterFlags.HWND_TOPMOST, 10, 10, 400, 300, SetWindowPosFlags.SWP_SHOWWINDOW);
        }

        private void buttonWindowNoTopMost_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = this.Handle;
            SetWindowPos(hWnd, SetWindowPosInsertAfterFlags.HWND_NOTOPMOST, 10, 10, 400, 300, SetWindowPosFlags.SWP_SHOWWINDOW);
        }

        private void buttonShowStartBar_Click(object sender, EventArgs e)
        {
            try
            {
                IntPtr hWnd = FindWindow("Shell_TrayWnd", null);

                if (hWnd != IntPtr.Zero)
                {
                    // Show the start bar
                    SetWindowPos(hWnd, SetWindowPosInsertAfterFlags.HWND_TOP, 0, 0, 240, 26, SetWindowPosFlags.SWP_SHOWWINDOW);
                }
            }
            catch
            {
                MessageBox.Show("Could not show Start Bar.");
            }
        }

        private void buttonHideStartBar_Click(object sender, EventArgs e)
        {
            try
            {
                IntPtr hWnd = FindWindow("Shell_TrayWnd", null);

                if (hWnd != IntPtr.Zero)
                {
                    // Hide the start bar
                    SetWindowPos(hWnd, SetWindowPosInsertAfterFlags.HWND_TOP, 0, 0, 0, 0, SetWindowPosFlags.SWP_HIDEWINDOW);
                }
            }
            catch
            {
                MessageBox.Show("Could not hide Start Bar.");
            }
        }
    }
}